rm(list=ls())
library(copula)
tau<-0.3  # dependence parameter
theta<-iTau(frankCopula(dim=2),tau=tau)  # calculate theta based on kendall's tau
lambda1<-2     # in-control parameter of first variable
lambda2<-2     # in-control parameter of second variable
lambda11<-2*2    # out-control parameter of first variable
lambda12<-2*0.75 # out-control parameter of second variable



#### Estamation of mean of T=min(y_i1,Y_i2)
F<-function(lambda1,lambda2,t)
{
  2-exp(-t/lambda1)-exp(-t/lambda2) +(1/theta)*log( 1+((exp(-theta*(1-exp(-t/lambda1)))-1)*(exp(-theta*(1-exp(-t/lambda2)))-1))/(exp(-theta)-1))
  
}

Fvar<-function(t)
{
  1-F(lambda1,lambda2,t)
}

A<-integrate(Fvar,0,+Inf)
ET<-A$value
alpha<-ET/370  
alpha1<-alpha*3/4
alpha2<-alpha*1/4
###### Calculating of LCL for downward shifts
LCL<-uniroot(function(t)  2-exp(-t/lambda1)-exp(-t/lambda2) +(1/theta)*log( 1+((exp(-theta*(1-exp(-t/lambda1)))-1)*(exp(-theta*(1-exp(-t/lambda2)))-1))/(exp(-theta)-1))-alpha1
             , lower = 0, upper = 5)$ root
###### Calculating of UCL for downward shifts
UCL<-uniroot(function(t)  2-exp(-t/lambda1)-exp(-t/lambda2) +(1/theta)*log( 1+((exp(-theta*(1-exp(-t/lambda1)))-1)*(exp(-theta*(1-exp(-t/lambda2)))-1))/(exp(-theta)-1))+alpha2-1
             , lower = 0, upper =20)$ root
#### Calculating the type II error


beta<-F(lambda11,lambda12,UCL)-F(lambda11,lambda12,LCL)


Fvar<-function(t)
{
  1-F(lambda11,lambda12,t)
}

A<-integrate(Fvar,0,+Inf)
ET1<-A$value
ATS1<-(1/(1-beta))*ET1


##########################simulation (downward shift)#########################
x<-mvdc(frankCopula(param=theta,dim=2)
        ,margins = c("exp","exp"),
        paramMargins =
          list(list(1/lambda11),list(1/lambda12)))

TS0<-c()
for(i in 1:2000)
{
  T<-1
  TS=0
  RL=0
  while (T>LCL&T<UCL)
  {
    dat<-rMvdc(1,x)
    T<-min(dat)
    TS<-TS+T
    RL<-RL+1
  }
  TS0[i]<-TS
  print(i)
}
ATSsim<-mean(TS0)

